# إصلاح الروابط للعمل من مجلد qr

## التغييرات التي تمت

تم تصحيح جميع الروابط في النظام لتعمل بشكل نسبي من داخل مجلد `qr`.

### الملفات المحدثة:

1. **core/Helpers.php** - دالة مساعدة جديدة لإدارة الروابط
2. **core/Autoloader.php** - إضافة تحميل Helpers
3. **includes/header.php** - تصحيح روابط CSS والقائمة
4. **includes/footer.php** - تصحيح روابط JavaScript
5. **login.php** - تصحيح الروابط
6. **logout.php** - تصحيح الروابط
7. **index.php** - تصحيح الروابط
8. **redirect.php** - تصحيح الروابط
9. **404.php, 403.php, error.php** - تصحيح الروابط
10. **qr/*.php** - جميع ملفات QR
11. **products/*.php** - جميع ملفات المنتجات
12. **warehouses/*.php** - جميع ملفات المخازن

## كيفية الاستخدام

### في ملفات PHP:
```php
// للروابط الداخلية
Core\Helpers::url('index.php')
Core\Helpers::url('qr/list.php')

// للملفات الثابتة (CSS, JS, Images)
Core\Helpers::asset('css/style.css')
Core\Helpers::asset('js/main.js')

// للـ Redirect
Core\Helpers::redirect('login.php')

// للحصول على Base URL الكامل (لرموز QR)
Core\Helpers::baseUrl()  // https://yourdomain.com/qr
```

## إعداد Base URL في config/app.php

عند التثبيت، يجب تعيين `base_url` في `config/app.php`:

```php
'base_url' => 'https://yourdomain.com/qr'
```

أو سيتم الكشف التلقائي من موقع الملف.

## ملاحظات مهمة

- جميع الروابط الآن نسبية وتعمل تلقائياً من أي مجلد
- لا حاجة لتغيير الروابط يدوياً عند نقل الملفات
- النظام يتعرف تلقائياً على موقع التطبيق

