<?php
/**
 * Login Page
 */

require_once __DIR__ . '/core/Autoloader.php';

use Core\Auth;
use Core\Security;

$auth = new Auth();

// Redirect if already logged in
if ($auth->check()) {
    Core\Helpers::redirect('index.php');
}

$error = '';

if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    // Validate CSRF token
    $token = $_POST['_token'] ?? '';
    if (!Security::validateCSRFToken($token)) {
        $error = 'Invalid security token';
    } else {
        $username = Security::sanitizeInput($_POST['username'] ?? '');
        $password = $_POST['password'] ?? '';
        
        $result = $auth->login($username, $password);
        
        if ($result['success']) {
            Core\Helpers::redirect('index.php');
        } else {
            $error = $result['message'];
        }
    }
}
?>
<!DOCTYPE html>
<html lang="ar" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>تسجيل الدخول - نظام إدارة رموز QR</title>
    <link rel="stylesheet" href="<?= Core\Helpers::asset('css/style.css') ?>">
</head>
<body class="login-page">
    <div class="login-container">
        <div class="login-box">
            <div class="login-header">
                <h1>نظام إدارة رموز QR</h1>
                <p>تسجيل الدخول للموظفين</p>
            </div>
            
            <?php if ($error): ?>
                <div class="alert alert-danger"><?= Security::sanitizeOutput($error) ?></div>
            <?php endif; ?>
            
            <form method="POST" class="login-form">
                <?= Security::getCSRFTokenField() ?>
                
                <div class="form-group">
                    <label for="username">اسم المستخدم أو البريد الإلكتروني:</label>
                    <input type="text" id="username" name="username" required autofocus>
                </div>
                
                <div class="form-group">
                    <label for="password">كلمة المرور:</label>
                    <input type="password" id="password" name="password" required>
                </div>
                
                <button type="submit" class="btn btn-primary btn-block">تسجيل الدخول</button>
            </form>
        </div>
    </div>
</body>
</html>
