<?php
/**
 * View Product Details
 */

require_once __DIR__ . '/../core/Autoloader.php';

use Core\Auth;
use Core\Security;
use Core\Database;

$auth = new Auth();
$auth->requireAuth();

$db = Database::getInstance();
$id = $_GET['id'] ?? 0;

$product = $db->fetch(
    "SELECT p.*, b.name as branch_name 
     FROM products p
     LEFT JOIN branches b ON p.branch_id = b.id
     WHERE p.id = ?",
    [$id]
);

if (!$product) {
    Core\Helpers::redirect('404.php');
}

// Get related QR codes
$qrCodes = $db->fetchAll(
    "SELECT * FROM qr_codes WHERE product_id = ? ORDER BY created_at DESC",
    [$id]
);

$pageTitle = 'تفاصيل المنتج';
include '../includes/header.php';
?>

<div class="page-header">
    <h1><?= Security::sanitizeOutput($product['name']) ?></h1>
    <?php if ($auth->hasPermission('products.edit')): ?>
        <a href="<?= Core\Helpers::url('products/edit.php?id=' . $product['id']) ?>" class="btn btn-secondary">تعديل</a>
    <?php endif; ?>
</div>

<div class="grid-2">
    <div class="card">
        <h2>معلومات المنتج</h2>
        <table class="info-table">
            <tr>
                <th>SKU:</th>
                <td><code><?= Security::sanitizeOutput($product['sku']) ?></code></td>
            </tr>
            <tr>
                <th>الاسم:</th>
                <td><?= Security::sanitizeOutput($product['name']) ?></td>
            </tr>
            <tr>
                <th>الموديل:</th>
                <td><?= Security::sanitizeOutput($product['model'] ?? '-') ?></td>
            </tr>
            <tr>
                <th>النوع:</th>
                <td><?= Security::sanitizeOutput($product['type']) ?></td>
            </tr>
            <tr>
                <th>الفرع:</th>
                <td><?= Security::sanitizeOutput($product['branch_name']) ?></td>
            </tr>
            <?php if ($product['description']): ?>
            <tr>
                <th>الوصف:</th>
                <td><?= nl2br(Security::sanitizeOutput($product['description'])) ?></td>
            </tr>
            <?php endif; ?>
        </table>
    </div>
    
    <div class="card">
        <h2>الملفات</h2>
        <?php if ($product['datasheet_pdf']): ?>
            <p><a href="<?= Core\Helpers::url('uploads/products/' . $product['datasheet_pdf']) ?>" target="_blank" class="btn btn-primary">تحميل Datasheet PDF</a></p>
        <?php endif; ?>
        <?php if ($product['catalog_pdf']): ?>
            <p><a href="<?= Core\Helpers::url('uploads/products/' . $product['catalog_pdf']) ?>" target="_blank" class="btn btn-primary">تحميل Catalog PDF</a></p>
        <?php endif; ?>
        <?php if ($product['video_url']): ?>
            <p><a href="<?= Security::sanitizeOutput($product['video_url']) ?>" target="_blank" class="btn btn-primary">مشاهدة فيديو</a></p>
        <?php endif; ?>
    </div>
</div>

<?php if ($product['installation_guide']): ?>
<div class="card">
    <h2>تعليمات التركيب والتشغيل</h2>
    <div><?= nl2br(Security::sanitizeOutput($product['installation_guide'])) ?></div>
</div>
<?php endif; ?>

<?php if ($product['safety_warnings']): ?>
<div class="card">
    <h2>تحذيرات السلامة</h2>
    <div style="background: #fff3cd; padding: 1rem; border-radius: 4px;">
        <?= nl2br(Security::sanitizeOutput($product['safety_warnings'])) ?>
    </div>
</div>
<?php endif; ?>

<?php if (!empty($qrCodes)): ?>
<div class="card">
    <h2>رموز QR المرتبطة</h2>
    <div class="table-container">
        <table class="data-table">
            <thead>
                <tr>
                    <th>الكود</th>
                    <th>العنوان</th>
                    <th>عدد المسحات</th>
                    <th>الإجراءات</th>
                </tr>
            </thead>
            <tbody>
                <?php foreach ($qrCodes as $qr): ?>
                    <tr>
                        <td><code><?= Security::sanitizeOutput($qr['short_code']) ?></code></td>
                        <td><?= Security::sanitizeOutput($qr['title']) ?></td>
                        <td><?= number_format($qr['scan_count']) ?></td>
                        <td>
                            <a href="<?= Core\Helpers::url('qr/view.php?id=' . $qr['id']) ?>" class="btn btn-sm btn-primary">عرض</a>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    </div>
</div>
<?php endif; ?>

<?php include '../includes/footer.php'; ?>
