<?php
/**
 * Warehouses Management
 */

require_once __DIR__ . '/../core/Autoloader.php';

use Core\Auth;
use Core\Security;
use Core\Database;

$auth = new Auth();
$auth->requirePermission('warehouses.view');

$db = Database::getInstance();
$user = $auth->user();

$branchId = $user['branch_id'] ?? $_GET['branch_id'] ?? null;
$search = $_GET['search'] ?? '';

$where = ['1=1'];
$params = [];

if ($branchId && !$auth->hasPermission('*')) {
    $where[] = "w.branch_id = ?";
    $params[] = $branchId;
}

if ($search) {
    $where[] = "(w.name LIKE ? OR w.code LIKE ? OR w.location LIKE ?)";
    $searchTerm = "%{$search}%";
    $params[] = $searchTerm;
    $params[] = $searchTerm;
    $params[] = $searchTerm;
}

$whereClause = implode(' AND ', $where);

$warehouses = $db->fetchAll(
    "SELECT w.*, b.name as branch_name,
     (SELECT COUNT(*) FROM inventory WHERE warehouse_id = w.id) as item_count
     FROM warehouses w
     LEFT JOIN branches b ON w.branch_id = b.id
     WHERE {$whereClause}
     ORDER BY w.name",
    $params
);

$pageTitle = 'إدارة المخازن';
include '../includes/header.php';
?>

<div class="page-header">
    <h1>إدارة المخازن</h1>
    <?php if ($auth->hasPermission('warehouses.create')): ?>
        <a href="<?= Core\Helpers::url('warehouses/create.php') ?>" class="btn btn-primary">إضافة مخزن جديد</a>
    <?php endif; ?>
</div>

<div class="filters-card">
    <form method="GET" class="filter-form">
        <input type="text" name="search" placeholder="بحث" value="<?= Security::sanitizeOutput($search) ?>">
        <button type="submit" class="btn btn-secondary">بحث</button>
    </form>
</div>

<div class="warehouse-grid">
    <?php foreach ($warehouses as $warehouse): ?>
        <div class="warehouse-card">
            <h3><?= Security::sanitizeOutput($warehouse['name']) ?></h3>
            <div class="warehouse-info">
                <p><strong>الكود:</strong> <code><?= Security::sanitizeOutput($warehouse['code']) ?></code></p>
                <p><strong>الفرع:</strong> <?= Security::sanitizeOutput($warehouse['branch_name']) ?></p>
                <p><strong>الموقع:</strong> <?= Security::sanitizeOutput($warehouse['location'] ?? '-') ?></p>
                <p><strong>عدد العناصر:</strong> <?= $warehouse['item_count'] ?></p>
            </div>
            <div class="warehouse-actions">
                <a href="<?= Core\Helpers::url('warehouses/view.php?id=' . $warehouse['id']) ?>" class="btn btn-primary">عرض</a>
                <?php if ($auth->hasPermission('warehouses.edit')): ?>
                    <a href="<?= Core\Helpers::url('warehouses/edit.php?id=' . $warehouse['id']) ?>" class="btn btn-secondary">تعديل</a>
                <?php endif; ?>
            </div>
        </div>
    <?php endforeach; ?>
</div>

<?php include '../includes/footer.php'; ?>
